% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eez.R
\name{eez}
\alias{eez}
\title{Compute the Exclusive Economic Zone (EEZ) for the Azores}
\usage{
eez(crs = laea_azores_proj(), distance = 200)
}
\arguments{
\item{crs}{Character or CRS object. The target coordinate reference system
(CRS) for the EEZ output. Defaults to \code{laea_azores_proj()} (a custom
Lambert Azimuthal Equal-Area projection centered on the Azores).}

\item{distance}{Numeric. The buffer distance in nautical miles (NM) around
each island. Defaults to \code{200} (200 NM, the standard EEZ definition). If
another value is provided, it will be converted to meters.}
}
\value{
An \code{sf} object representing the EEZ as a single POLYGON.
}
\description{
This function calculates the Exclusive Economic Zone (EEZ) boundary for
the Azores by buffering each island by a specified distance (default 200
nautical miles) and merging the resulting buffers to create a single EEZ
polygon.
}
\details{
The EEZ is defined as the area \strong{200 nautical miles from the nearest baseline of each
island}. This function:
\itemize{
\item Buffers each island by \verb{distance × 1,852} meters (default: \strong{370,400 meters}).
\item Merges overlapping buffers into a single EEZ boundary.
\item Transforms the final EEZ to the specified \code{crs}.
}
}
\examples{
\donttest{
library(ggplot2)
ggplot() +
geom_sf(data = eez(), fill = NA, linewidth = 1, col = "gray") +
 geom_sf(data = districts(), mapping = aes(fill = district), col = "white") +
 guides(fill = "none")

# WGS 84 projection
ggplot() +
geom_sf(data = eez(crs = "EPSG:4326"), fill = NA, linewidth = 1, col = "gray") +
 geom_sf(data = districts(crs = "EPSG:4326"), mapping = aes(fill = district), col = "white") +
 guides(fill = "none")}


}
