% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-and-validate-data.R
\name{convert_columns}
\alias{convert_columns}
\title{Check and Convert Columns in Dataset}
\usage{
convert_columns(dataset)
}
\arguments{
\item{dataset}{A data frame containing the dataset to be checked and modified.}
}
\value{
A modified version of the input dataset with the specified columns converted to factors or numeric types, as appropriate.
}
\description{
This function checks the data types of specific columns in the provided dataset and converts them to the desired data type if necessary.
The function is designed to ensure that certain columns are represented as factors or numeric values, as required for further analysis.
}
\examples{
# Sample dataset
data <- data.frame(
                Project = c("Project A", "Project A", "Project B"),
                Date = c("2023-07-31", "2023-08-01", "2023-08-02"),
                Site = c("Site X", "Site Y", "Site Z"),
                Country = c("Country A", "Country B", "Country C"),
                Latitude = c(34.05, 36.16, 40.71),
                Longitude = c(-118.24, -115.15, -74.01),
                Species = c("Species 1", "Species 2", "Species 3"),
                Genotype = c("Genotype A", "Genotype B", "Genotype C"),
                Condition = c("Condition 1", "Condition 2", "Condition 3"),
                Timepoint = c("Timepoint 1", "Timepoint 1", "Timepoint 2"),
                Temperature = c(30.2, 31.5, 29.8),
                Pam_value = c(0.5, 0.6, 0.8)
                )

# Convert columns in the dataset
modified_data <- convert_columns(data)

# The 'Site', 'Condition', 'Species', and 'Genotype' columns are now factors,
# and 'Temperature' and 'PAM' columns are now numeric in the modified_data.
}
