% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{harmonic_centrality}
\alias{harmonic_centrality}
\title{Harmonic Centrality}
\usage{
harmonic_centrality(
  x,
  vids = V(x),
  mode = c("all", "out", "in"),
  weights = NULL
)
}
\arguments{
\item{x}{An igraph or a network object.}

\item{vids}{Nodes to be considered in the calculation.}

\item{mode}{A character value, indicating the type of degree to consider ("out" for out-degree, "in" for in-degree, "total" for the sum of the two). For undirected graphs, this argument is ignored. The default value is "total".}

\item{weights}{Numeric vector indicating weights of the edges.}
}
\value{
A numeric vector of centrality values for each node. The length of the vector is equal to the number of nodes in the network.
}
\description{
This function computes the Harmonic Centrality for nodes in a network. The harmonic centrality metric is defined as the denormalized reciprocal of the harmonic mean of all distances.
}
\examples{

data(zachary)

harmonic_centrality(zachary)

}
\references{
BOLDI, P. & VIGNA, S. 2014. Axioms for centrality. Internet Mathematics, 00-00.

MARCHIORI, M. & LATORA, V. 2000. Harmony in the small-world. Physica A: Statistical Mechanics and its Applications, 285, 539-546.

OPSAHL, T., AGNEESSENS, F. & SKVORETZ, J. 2010. Node centrality in weighted networks: Generalizing degree and shortest paths. Social Networks, 32, 245-251.

OPSAHL, T. 2010. Closeness centrality in networks with disconnected components (http://toreopsahl.com/2010/03/20/closeness-centrality-in-networks-with-disconnected-components/)
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
