% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{misc_extract_components}
\alias{misc_extract_components}
\title{Component extraction of miscellaneous graph formats}
\usage{
misc_extract_components(
  x,
  directed = TRUE,
  mode = "directed",
  weighted = NULL,
  unibipartite = FALSE,
  diag = TRUE
)
}
\arguments{
\item{x}{The input can be an edgelist, an adjacency matrix, or a graphNEL object.}

\item{directed}{Whether to create a directed graph. (default = TRUE)}

\item{mode}{Character scalar, explains how to interpret the supplied matrix.
Possible values are: "directed", "undirected", "upper", "lower", "max", "min", "plus". (default = "directed")}

\item{weighted}{An argument for specifying whether the graph should be weighted or not.
If it is NULL, then an unweighted graph is created. (default = NULL)}

\item{unibipartite}{A boolean parameter describing whether the input edge list corresponds
to a bipartite graph. A TRUE value specifies a bipartite graph, and vice versa. (default = FALSE)}

\item{diag}{Logical scalar, whether to consider the diagonal of the matrix or not.
If it is FALSE, then the diagonal is treated as zeros. (default = TRUE)}
}
\value{
A list including the components of the input graph as igraph objects.
Each element of the list represents a component and is an igraph object.
The components are disconnected subgraphs of the input graph.
}
\description{
This function extracts all components of the input with various formats
and converts them to "igraph" objects.
}
\details{
This function extracts components from the input object, which can be an edgelist,
an adjacency matrix, or a graphNEL object. The result is a list including the components
represented as separate graphs.
}
\seealso{
\code{\link[igraph]{induced.subgraph}}, \code{\link[igraph]{components}},
\code{\link[igraph]{graph_from_adjacency_matrix}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
