% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_RL.R
\name{RL}
\alias{RL}
\title{RL Test}
\usage{
RL(y, treatment, block1, block2)
}
\arguments{
\item{y}{a numericc vector for the response variable.}

\item{treatment}{a vector giving the treatment type for the corresponding
elements of \code{y}.}

\item{block1}{a vector giving the first blocking variable for the
corresponding elements of \code{y}.}

\item{block2}{a vector giving the second blocking variable for the
corresponding elements of \code{y}.}
}
\value{
A list containing the RL test statistic adjusted for ties together with the
associated p-value using a chi-squared distribution with t-1 degrees of
freedom.
}
\description{
\code{RL} returns the test statistic and p-value for the RL test. This test
is applicable to Latin square designs. The test is not recommended though as
block effects contaminate the response variable leading to unacceptable test
size.
}
\examples{
attach(peanuts)
RL(y = yield, treatment = treatment, block1 = row, block2 = col)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
\seealso{
\code{\link[=ARL]{ARL()}} \code{\link[=CARL]{CARL()}}
}
