% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gendata_simu}
\alias{gendata_simu}
\title{Generate simulated data}
\usage{
gendata_simu(
  seed = 1,
  n = 300,
  p = 50,
  d = 20,
  q = 6,
  rank0 = 3,
  rho = c(1.5, 1),
  sigma2_eps = 0.1,
  seed.beta = 1
)
}
\arguments{
\item{seed}{a postive integer, the random seed for reproducibility of data generation process.}

\item{n}{a postive integer, specify the sample size.}

\item{p}{a postive integer, specify the dimension of count variables.}

\item{d}{a postive integer,  specify the dimension of covariate matrix.}

\item{q}{a postive integer,  specify the number of factors.}

\item{rank0}{a postive integer, specify the rank of the coefficient matrix.}

\item{rho}{a numeric vector with length 2 and positive elements, specify the signal strength of regression coefficient and loading matrix, respectively.}

\item{sigma2_eps}{a positive real, the variance of overdispersion error.}

\item{seed.beta}{a postive integer, the random seed for reproducibility of data generation process by fixing the regression coefficient matrix beta.}
}
\value{
return a list including the following components: (1) X, the high-dimensional count matrix; (2) Z, the high-dimensional covriate matrix; (3) bbeta0, the low-rank large coefficient matrix; (4) B0, the loading matrix; (5) H0, the factor matrix; (6) rank: the true rank of bbeta0; (7) q: the true number of factors.
}
\description{
Generate simulated data from covariate-augmented Poisson factor models
}
\details{
None
}
\examples{
n <- 300; p <- 100
d <- 20; q <- 6; r <- 3
datlist <- gendata_simu(n=n, p=p, d=20, q=q, rank0=r)
str(datlist)
}
\references{
None
}
\seealso{
\code{\link{RR_COAP}}
}
