% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_units.R
\name{get_data_avail.coin}
\alias{get_data_avail.coin}
\title{Get data availability of units}
\usage{
\method{get_data_avail}{coin}(x, dset, out2 = "coin", ...)
}
\arguments{
\item{x}{A coin}

\item{dset}{String indicating name of data set in \code{.$Data}.}

\item{out2}{Either \code{"coin"} to output an updated coin or \code{"list"} to output a list.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated coin with data availability tables written in \code{.$Analysis[[dset]]}, or a
list of data availability tables.
}
\description{
Returns a list of data frames: the data availability of each unit (row) in a given data set, as well as percentage of zeros.
A second data frame gives data availability by aggregation (indicator) groups.
}
\details{
This function ignores any non-numeric columns, and returns a data availability table of numeric columns with non-numeric columns
appended at the beginning.

See also vignettes: \code{vignette("analysis")} and \code{vignette("imputation")}.
}
\examples{
# build example coin
coin <-  build_example_coin(up_to = "new_coin", quietly = TRUE)

# get data availability of Raw dset
l_dat <- get_data_avail(coin, dset = "Raw", out2 = "list")
head(l_dat$Summary, 5)

}
