% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{prc_change}
\alias{prc_change}
\title{Percentage change of time series}
\usage{
prc_change(y, x, per = 1)
}
\arguments{
\item{y}{A numeric vector}

\item{x}{A numeric vector of the same length as \code{y}, indexing \code{y} in time. No \code{NA} values are allowed
in \code{x}.}

\item{per}{Numeric value to scale the change according to a period of time. See description.}
}
\value{
Percentage change as a scalar value.
}
\description{
Calculates the percentage change in a time series from the initial value. The time series is defined by
\code{y} the response variable, indexed by \code{x}, the time variable. The \code{per} argument can optionally be used
to scale the result according to a period of time. E.g. if the units of \code{x} are years, setting \code{x = 10}
will measure the percentage change per decade.
}
\details{
This function operates in two ways, depending on the number of data points. If \code{x} and \code{y} have two non-\code{NA}
observations, percentage change is calculated using the first and last values. If three or more points are
available, a linear regression is used to estimate the average percentage change. If fewer than two points
are available, the percentage change cannot be estimated and \code{NA} is returned.

If all \code{y} values are equal, it will return a change of zero.
}
\examples{
# a time vector
x <- 2011:2020

# some random points
y <- runif(10)

# find percentage change per decade
prc_change(y, x, 10)
}
