% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_compute.R
\name{pi_compute}
\alias{pi_compute}
\title{Compute Probability of Each True Outcome, for Every Subject}
\usage{
pi_compute(beta, X, n, n_cat)
}
\arguments{
\item{beta}{A numeric column matrix of regression parameters for the
\code{Y} (true outcome) ~ \code{X} (predictor matrix of interest).}

\item{X}{A numeric design matrix.}

\item{n}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
can take.}
}
\value{
\code{pi_compute} returns a matrix of probabilities,
\eqn{P(Y_i = j | X_i) = \frac{\exp(X_i \beta)}{1 + \exp(X_i \beta)}}
for each of the \eqn{i = 1, \dots,} \code{n} subjects. Rows of the matrix
correspond to each subject. Columns of the matrix correspond to the true outcome
categories \eqn{j = 1, \dots,} \code{n_cat}.
}
\description{
Compute Probability of Each True Outcome, for Every Subject
}
