% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpest.R
\name{cpest}
\alias{cpest}
\title{Estimates change point using shifted intervals}
\usage{
cpest(time, event, cpmax, intwd, cpmin, norm.riskset)
}
\arguments{
\item{time}{Numeric vector with survival times.}

\item{event}{Numeric vector indicating censoring status; 0 = alive (censored), 1 =
dead (uncensored). If missing, all observations are assumed to be
uncensored.}

\item{cpmax}{Upper bound for estimated change point. Time period is split into
intervals up to this point. Has to be an integer value.}

\item{intwd}{Width of intervals into which the time period is split; default
is \code{ceiling(cpmax/20)}. Has to be an integer value.}

\item{cpmin}{Lower bound for estimated change point; default is
\code{cpmin=0}. Has to be an integer value.}

\item{norm.riskset}{Logical; if \code{TRUE} normalized number of units at
risk is used within an interval.}
}
\value{
A list with estimated change point, p-values of exact binomial
  test, mean of p-values above estimated change point (part of regression
  function), lower and upper bounds of confidence intervals.
}
\description{
Shifts intervals iteratively and estimates change point at each step. Final
change point is calculated by optimization over all estimations.
}
\seealso{
\code{\link{cpsurv}}
}
