% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRingFromImage.R
\name{addRingFromImage}
\alias{addRingFromImage}
\title{Add ring to pith to bark profile from CT scan image}
\usage{
addRingFromImage(n = 1, densProfile, im)
}
\arguments{
\item{n}{Number of rings to add}

\item{densProfile}{Density profile}

\item{im}{Density matrix}
}
\value{
Corrected density profile with new ring(s) added and blue bar in plot of added ring
}
\description{
Add ring to pith to bark profile from CT scan image
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
image_info <- getImageInfo(hdr = hdr_df)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens,
                          n_segments = 12,
                          pixel = TRUE,
                          toPlot = FALSE)

endPath <- c(472, 284)

densPath <- extractProfile(im_dens,
                           image_info,
                           pith_coord,
                           endPath,
                           k = 2, r = 5,
                           threshold = 0.002)

newPath2 <- addRingFromImage(n = 1, densPath, im_dens)

}
