% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractProfile.R
\name{extractProfile}
\alias{extractProfile}
\title{Get profile between two points of the CTScan image matrix}
\usage{
extractProfile(
  im,
  imHeader,
  beginPath,
  endPath,
  r = 10,
  k = 2,
  threshold = 0.01
)
}
\arguments{
\item{im}{Density matrix}

\item{imHeader}{image header}

\item{beginPath}{X,Y coordinates of the start point of the path}

\item{endPath}{X,Y coordinates of the start point of the path}

\item{r}{Profile width}

\item{k}{Rolling window width, integer}

\item{threshold}{Threshold value between maximum and minimum density to establish change of ring}
}
\value{
Density profile
}
\description{
Get profile between two points of the CTScan image matrix
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual
# not run - endPath <- locatePathEnd(im_dens, pith_coord) # using the image

path <- extractProfile(im_dens, image_info, pith_coord, endPath, k = 2, r = 5, threshold = 0.002)

}
