% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getImageInfo.R
\name{getImageInfo}
\alias{getImageInfo}
\title{Extract from header of CT scan image grayscale number of bits and pixel size}
\usage{
getImageInfo(hdr)
}
\arguments{
\item{hdr}{Header dataframe}
}
\value{
List with grayscale values, and pixel size
}
\description{
Extract from header of CT scan image grayscale number of bits and pixel size
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
getImageInfo(hdr = hdr_df)

}
