% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifyPith.R
\name{verifyPith}
\alias{verifyPith}
\title{Check if pith location is correct}
\usage{
verifyPith(im, pith_coord)
}
\arguments{
\item{im}{Density matrix of image}

\item{pith_coord}{Pith coordinates}
}
\value{
Corrected pith coordinates
}
\description{
Check if pith location is correct
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

pith_coord_checked <- verifyPith(im_dens, pith_coord)

}
