% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_covar_balance.R
\name{check_covar_balance}
\alias{check_covar_balance}
\title{Check covariate balance}
\usage{
check_covar_balance(
  w,
  c,
  ci_appr,
  counter_weight = NULL,
  covar_bl_method = "absolute",
  covar_bl_trs = 0.1,
  covar_bl_trs_type = "mean"
)
}
\arguments{
\item{w}{A vector of observed continuous exposure variable.}

\item{c}{A data.frame of observed covariates variable.}

\item{ci_appr}{The causal inference approach.}

\item{counter_weight}{A weight vector in different situations. If the
matching approach is selected, it is an integer data.table of counters.
In the case of the weighting approach, it is weight data.table.}

\item{covar_bl_method}{Covariate balance method. Available options:
- 'absolute'}

\item{covar_bl_trs}{Covariate balance threshold.}

\item{covar_bl_trs_type}{Covariate balance type (mean, median, maximal).}
}
\value{
output object:
\itemize{
\item corr_results
\itemize{
\item absolute_corr
\item mean_absolute_corr
}
\item pass (TRUE,FALSE)
}
}
\description{
Checks the covariate balance of original population or pseudo population.
}
\examples{
\donttest{
set.seed(422)
n <- 100
mydata <- generate_syn_data(sample_size=n)
year <- sample(x=c("2001","2002","2003","2004","2005"),size = n,
              replace = TRUE)
region <- sample(x=c("North", "South", "East", "West"),size = n,
                replace = TRUE)
mydata$year <- as.factor(year)
mydata$region <- as.factor(region)
mydata$cf5 <- as.factor(mydata$cf5)

m_xgboost <- function(nthread = 1,
                      ntrees = 35,
                      shrinkage = 0.3,
                      max_depth = 5,
                      ...) {SuperLearner::SL.xgboost(
                        nthread = nthread,
                        ntrees = ntrees,
                        shrinkage=shrinkage,
                        max_depth=max_depth,
                        ...)}

data_with_gps <- estimate_gps(.data = mydata,
                              .formula = w ~ cf1 + cf2 + cf3 + cf4 + cf5 +
                                             cf6 + year + region,
                              sl_lib = c("m_xgboost"),
                              gps_density = "kernel")


cw_object_matching <- compute_counter_weight(gps_obj = data_with_gps,
                                             ci_appr = "matching",
                                             bin_seq = NULL,
                                             nthread = 1,
                                             delta_n = 0.1,
                                             dist_measure = "l1",
                                             scale = 0.5)

pseudo_pop <- generate_pseudo_pop(.data = mydata,
                                  cw_obj = cw_object_matching,
                                  covariate_col_names = c("cf1", "cf2", "cf3",
                                                          "cf4", "cf5", "cf6",
                                                          "year", "region"),
                                  covar_bl_trs = 0.1,
                                  covar_bl_trs_type = "maximal",
                                  covar_bl_method = "absolute")


adjusted_corr_obj <- check_covar_balance(w = pseudo_pop$.data[, c("w")],
                                         c = pseudo_pop$.data[ ,
                                         pseudo_pop$params$covariate_col_names],
                                         counter = pseudo_pop$.data[,
                                                     c("counter_weight")],
                                         ci_appr = "matching",
                                         covar_bl_method = "absolute",
                                         covar_bl_trs = 0.1,
                                         covar_bl_trs_type = "mean")
}
}
