% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortfit.R
\name{sortfit}
\alias{sortfit}
\title{Executes an NLME simple estimation with sort keys and given scenarios}
\usage{
sortfit(
  model,
  hostPlatform = NULL,
  params,
  sortColumns,
  scenarios = list(),
  simpleTables,
  runInBackground = FALSE,
  filesToReturn = "*",
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, PhoenixMPIDir64 is given  and MPI is installed,
MPI local host with 4 threads is used. If MPI is not found, local host
without parallelization is used.}

\item{params}{Engine parameters. See \code{\link{engineParams}}.
If \code{missing}, default parameters generated by engineParams(model) are used.}

\item{sortColumns}{List of sort columns. See \code{\link{SortColumns}}.
If \code{missing}, empty sort columns argument is used and NLME dataset is used as is.}

\item{scenarios}{List of scenarios with different sets of covariates.
See \code{\link{NlmeScenario}}
If \code{missing}, all covariates effects are considered as enabled.}

\item{simpleTables}{Optional list of simple tables. See
\code{\link{tableParams}}. By default a table named 'posthoc.csv' is returned
with structural parameters values for all source data rows.}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{filesToReturn}{Used to specify which files to be outputted to the model directory
and loaded as returned value. By default, all the applicable files listed
in the \code{Value} section will be outputted to the model directory and loaded as returned value.
Only those files listed in the \code{Value} section can be specified.
Simple regex patterns are supported for the specification.}

\item{...}{Additional arguments for  \code{\link{hostParams}}
or arguments available inside \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both the \code{hostPlatform}
argument and the ellipses, values supplied to \code{hostPlatform} will be overridden by
additional arguments supplied via the ellipses e.g., \code{...}.}
}
\value{
if \code{runInBackground} is \code{FALSE}, a list with  main
resulted dataframes is returned:
\itemize{
\item Overall
\item ConvergenceData
\item residuals
\item Secondary
\item StrCovariate  - if continuous covariates presented
\item StrCovariateCat - if categorical covariates presented
\item theta
\item posthoc table
\item posthocStacked table
\item Requested tables
}

\code{nlme7engine.log} textual output is returned and loaded with the main information related to
fitting. \code{dmp.txt} structure with the results of fitting (including LL by subject information)
is returned and loaded. These 2 files are returned and loaded irrespective of
\code{filesToReturn} argument value.

For individual models, additional dataframe with partial derivatives is returned:
\itemize{
\item ParDer
}

For population models and the method specified is NOT \code{Naive-Pooled},
additional dataframes are returned:
\itemize{
\item omega
\item Eta
\item EtaStacked
\item EtaEta
\item EtaCov
\item EtaCovariate - if continuous covariates presented
\item EtaCovariateCat - if categorical covariates presented
\item bluptable.dat
}

If standard error computation was requested and it was successful, additional dataframes
are returned:
\itemize{
\item thetaCorrelation
\item thetaCovariance
\item Covariance
\item omega_stderr
}

If nonparametric method was requested (\code{numIterNonParametric} > 0) and
the \code{method} specified in \code{engineParams}  is NOT \code{Naive-Pooled},
additional dataframes are returned:
\itemize{
\item nonParSupportResult
\item nonParStackedResult
\item nonParEtaResult
\item nonParOverallResult
}

if \code{runInBackground} is \code{TRUE}, only current status of job is returned.
}
\description{
Executes an NLME simple estimation with sort keys and given scenarios
}
\details{
All the results in tabular format have scenario column and sorts columns appended.
The resulted logs (nlme7engine.log, err1.txt, dmp.txt, out.txt) are appended with a row delimiter
where the name of the Scenario and sort values are specified.
}
\section{Non-loaded but returned files}{

The non-loaded but returned files in the model working directory are:
\itemize{
\item err1.txt - concatenated for all runs detailed logs for all steps of optimization,
\item out.txt - general pivoted information about results,
\item doses.csv - information about doses given for all subjects,
\item iniest.csv - information about initial estimates
}
}

\examples{
\dontrun{
input_data <- pkData

model <-
  pkmodel(numCompartments = 2,
          data = input_data,
          ID = "Subject",
          Time = "Act_Time",
          A1 = "Amount",
          CObs = "Conc",
          workingDir = tempdir())

model <-
  addCovariate(model,
               covariate = "BodyWeight",
               direction = "Backward",
               center = "Mean",
               effect = c("V", "Cl"))

# multicore
multicoreHost <-
   hostParams(parallelMethod = "Multicore",
              hostName = "multicore",
              numCores = 4,
              sharedDirectory = tempdir())

# specify scenarios
CovariateEffectNames <- listCovariateEffectNames(model)
combinations <-
  combn(c("", CovariateEffectNames),
        length(CovariateEffectNames),
        simplify = FALSE)

scenarioNames <-
  lapply(combinations,
         function(x) {paste(x, collapse = " ")})

scenarios <-
  lapply(scenarioNames,
         function(x, CovariateEffectNames) {
           CovariateCombinations <- unlist(strsplit(x, " ", fixed = TRUE))
           scenarioIndex <-
             paste(which(CovariateEffectNames \%in\% CovariateCombinations,
                         arr.ind = TRUE),
                         collapse = ", ")
           NlmeScenario(trimws(x), scenarioIndex)
         },
         CovariateEffectNames)

res <-
  sortfit(model,
          hostPlatform = multicoreHost,
          params = engineParams(model, numIterations = 5, fastOptimization = TRUE),
          sortColumns = SortColumns("Gender"),
          scenarios = scenarios)

}
}
\seealso{
\code{\link{hostParams}, \link{engineParams},  \link{SortColumns},
\link{NlmeScenario}, \link{tableParams}}
}
