% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taiwan_model.R
\name{taiwan_model}
\alias{taiwan_model}
\title{Taiwan model}
\usage{
taiwan_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill-units for each temperature of vector (Total = FALSE), or returns the chill-units accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by means of converting temperatures to chill-units.
}
\details{
The model is based on chill-units, where 1 chill-unit is when the tree is exposure below 7.2°C. When the temperature is between 15.1°C and 26.6°C, there isn't accumulation of chill-unit. The chill-units accumulation is negative when occurs temperature above 26.7°C, and the chill-unit is -1 when occurs temperature above 27.8°C.
}
\examples{

x <- rnorm(500, 20, 7)
taiwan_model(x)
taiwan_model(x, FALSE)

}
\references{
LU, M. T. et al. 2012. A model for estimating chilling requirement of very low-chill peaches in Taiwan. Acta Horticulturae, n. 962, p. 245.
}
