% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utah_model.R
\name{utah_model}
\alias{utah_model}
\title{Utah Model}
\usage{
utah_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill-units for each temperature of vector (Total = FALSE), or returns the chill-units accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by means of converting temperatures to chill-units.
}
\details{
The model is based on chill-units, where 1 chill-unit is when the tree is exposure between 2.4°C and 9.1°C, being the optimum temperature 6°C . When the temperature is between 9.1°C and 12.4°C, the chill-unit is 0.5. The chill-units accumulation is 0 when occurs temperature below 1.4 and between 12.5°C and 15.9°C. When the temperature is between 16°C and 18°C, the chill-unit is -0.5. When the temperature is above 18°C, the chill-unit is -1.
}
\examples{

x <- rnorm(500, 5, 3)
utah_model(x)
utah_model(x, FALSE)

}
\references{
Richardson, E, A. et al. 1974. "A Model for Estimating the Completation of Rest for 'Redhaven' and 'Elberta' Peach Trees". Research Reports & Notes.
}
