% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{csdi}
\alias{csdi}
\title{Cold spell duration}
\usage{
csdi(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{daily minimum temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
days
}
\description{
Count of days with at least 6 consecutive days when TN < 10th percentile. The 10th percentile is computed based on the time scale selected (month, season or year) not daily as ETCCDI does. If you want to compute daily you can use RClimDex package.
}
\examples{
data(data_all)
csdi(data=data_all$tn)
}
