% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-2-graph-construction.R
\name{get_highest_prune_param_embedding}
\alias{get_highest_prune_param_embedding}
\title{Calculate the highest pruning parameter for the SNN graph given Embedding}
\usage{
get_highest_prune_param_embedding(embedding, n_neigh)
}
\arguments{
\item{embedding}{A matrix associated with a PCA embedding. Embeddings from
other dimensionality reduction techniques (such as LSI) can be used.}

\item{n_neigh}{The number of nearest neighbours.}
}
\value{
The value of the highest pruning parameter.
}
\description{
Given an embedding, the function calculates the highest pruning
parameter for the SNN graph that preserves the connectivity of the graph.
}
\note{
Given the way the SNN graph is built, the possible values for the pruning
parameter are limited and can be determined by the formula \code{i / (2 * n_neigh - i)},
where \code{i} is a number of nearest neighbours between 0 and \code{n_neigh}.
}
\examples{
set.seed(2024)
# create an artificial pca embedding
pca_embedding <- matrix(
    c(runif(100 * 10), runif(100 * 10, min = 3, max = 4)),
    nrow = 200, byrow = TRUE
)
rownames(pca_embedding) <- as.character(1:200)
colnames(pca_embedding) <- paste("PC", 1:10)

get_highest_prune_param_embedding(pca_embedding, 5)
}
