% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bss.R
\name{bss_test}
\alias{bss_test}
\title{Bautista, Smith and Steiner test for multiple comparisons}
\usage{
bss_test(
  y,
  trt,
  alpha = 0.05,
  show_plot = TRUE,
  console = TRUE,
  abline_options,
  ...
)
}
\arguments{
\item{y}{Either a model (created with \code{lm()} or \code{aov()}) or a numerical
vector with the values of the response variable for each unit.}

\item{trt}{If \code{y} is a model, a string with the name of the column containing
the treatments. If \code{y} is a vector, a vector of the same length as \code{y}
with the treatments for each unit.}

\item{alpha}{Numeric value corresponding to the
significance level of the test. The default value is 0.05.}

\item{show_plot}{Logical value indicating whether the constructed dendrogram
should be plotted or not.}

\item{console}{Logical value indicating whether the results should be printed
on the console or not.}

\item{abline_options}{\code{list} with optional arguments for the line in the
dendrogram.}

\item{...}{Optional arguments for the \code{plot()} function.}
}
\value{
A list with three \code{data.frame} and one \code{hclust}:
\item{stats}{\code{data.frame} containing summary statistics by treatment.}
\item{groups}{\code{data.frame} indicating the group to which each treatment is
assigned.}
\item{parameters}{\code{data.frame} with the values used for the test.
\code{treatments} is the total number of treatments and \code{alpha} is the
significance level used.}
\item{dendrogram_data}{object of class \code{hclust} with data used to build
the dendrogram.}
}
\description{
Bautista, Smith and Steiner (BSS) test for multiple comparisons.
Implements a procedure for grouping treatments following the determination of
differences among them. First, a cluster analysis of the treatment means is
performed and the two closest means are grouped. A nested analysis of
variance from the original ANOVA is then constructed with the treatment
source now partitioned into "groups" and "treatments within groups". This
process is repeated until there are no differences among the group means or
there are differences among the treatments within groups.
}
\examples{
data("PlantGrowth")
# Using vectors -------------------------------------------------------
weights <- PlantGrowth$weight
treatments <- PlantGrowth$group
bss_test(y = weights, trt = treatments, show_plot = FALSE)
# Using a model -------------------------------------------------------
model <- lm(weights ~ treatments)
bss_test(y = model, trt = "treatments", show_plot = FALSE)
}
\references{
Bautista, M. G., Smith, D. W., & Steiner, R. L. (1997).
A Cluster-Based Approach to Means Separation. \emph{Journal of Agricultural,
Biological, and Environmental Statistics, 2}(2), 179-197.
\doi{doi:10.2307/1400402}
}
\author{
Santiago Garcia Sanchez
}
