% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{clustering}
\alias{clustering}
\title{Clustering algorithm.}
\usage{
clustering(
  path = NULL,
  df = NULL,
  packages = NULL,
  algorithm = NULL,
  min = 3,
  max = 4,
  metrics = NULL
)
}
\arguments{
\item{path}{The path of file. \code{NULL} It is only allowed to use path or
df but not both at the same time. Only files in .dat, .csv or arff format are
allowed.}

\item{df}{data matrix or data frame, or dissimilarity matrix. \code{NULL} If
you want to use training and test \code{basketball} attributes.}

\item{packages}{character vector with the packets running the algorithm.

\code{NULL} The seven packages implemented are: cluster, ClusterR, amap,
apcluster, pvclust. \cr By default runs all packages.}

\item{algorithm}{character vector with the algorithms implemented within the
package. \code{NULL} The algorithms implemented are: hclust,apclusterK,agnes,clara,daisy,
diana,fanny,mona,pam,gmm, kmeans_arma,kmeans_rcpp,mini_kmeans,pvclust.}

\item{min}{An integer with the minimum number of clusters This data is
necessary to indicate the minimum number of clusters when grouping the data.
The default value is \code{3}.}

\item{max}{An integer with the maximum number of clusters. This data is
necessary to indicate the maximum number of clusters when grouping the data.
The default value is \code{4}.}

\item{metrics}{Character vector with the metrics implemented to evaluate the
distribution of the data in clusters. \code{NULL} The night metrics
implemented are: Entropy, Variation_information,\cr
Precision,Recall,F_measure,Fowlkes_mallows_index,Connectivity,Dunn and Silhouette.}
}
\value{
A matrix with the result of running all the metrics of the algorithms
contained in the packages indicated. We also obtain information with the
types of metrics, algorithms and packages executed.

\itemize{
       \item result It is a list with the algorithms, metrics and variables
       defined in the execution of the algorithm.
       \item has_internal_metrics Boolean field to indicate if there are
       internal metrics such as: dunn, silhoutte and connectivity.
       \item has_external_metrics Boolean field to indicate if there are
       external metrics such as: precision, recall, f-measure, entropy,
       variation information and fowlkes-mallows.
       \item algorithms_execute Character vector with the algorithms
       executed. These algorithms have been mentioned in the definition of
       the parameters.
       \item measures_execute Character vector with the measures executed.
       These measures have been mentioned in the definition of the
       parameters.
}
}
\description{
Discovering the behavior of attributes in a set of clustering
packages based on evaluation metrics.
}
\details{
The operation of this algorithm is to evaluate how the attributes of
a dataset or a set of datasets behave in different clustering algorithms. To do
this, it is necessary to indicate the type of evaluation you want to make on
the distribution of the data. To be able to execute the algorithm it is necessary
to indicate the number of clusters.

\code{min} and \code{max}, the algorithms \code{algorithm} or packages.

\code{packages} that we want to cluster and the metrics \code{metrics}.
}
\examples{

Clustering::clustering(
     df = cluster::agriculture,
     min = 3,
     max = 3,
     algorithm='clara',
     metrics=c('Precision')
)



}
