% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{create_GlobalBarplot}
\alias{create_GlobalBarplot}
\title{Vertex-class pairs profile of shared features}
\usage{
create_GlobalBarplot(
  CompTreatTable,
  treat1 = "Treatment1",
  treat2 = "Treatment2",
  factorOrder = NULL,
  col1 = "red",
  col2 = "blue",
  maxpairs = 1,
  xlb = "Vertex-Class Pairs",
  ylb = "Number of pairs",
  szggrepel = 3.5,
  nudgey = 0.5,
  nudgex = 0.5,
  szaxisTxt = 12,
  szaxisTitle = 12
)
}
\arguments{
\item{CompTreatTable}{Output of Compare_VertexClasses_sharedEdgeFeatures}

\item{treat1}{Name of treatment one, default Treatment1. It should match the column names of the output of Compare_VertexClasses_sharedEdgeFeatures}

\item{treat2}{Name of treatment one, default Treatment2. It should match the column names of the output of Compare_VertexClasses_sharedEdgeFeatures}

\item{factorOrder}{A list specifying the order of the treatments.}

\item{col1}{Color for Treatment 1}

\item{col2}{Color for Treatment 2}

\item{maxpairs}{If number of class-vertex-pairs > maxpairs, display number pairs on top of bar}

\item{xlb}{Name for x-axis}

\item{ylb}{Name for the y-axis}

\item{szggrepel}{Size ggrepel labels}

\item{nudgey}{Nudge y ggrepel}

\item{nudgex}{Nudge x ggrepel}

\item{szaxisTxt}{Size axis text}

\item{szaxisTitle}{Size axis title}
}
\value{
A ggplot object for a barplot. The barplot shows the vertex-class pairs profile of all shared edge features between treatments
}
\description{
This function will create a barplot from the output of Compare_VertexClasses_sharedEdgeFeatures using all shared Edge Features (e.g., genes).
}
\examples{
data(VertexClassesSharedGenes_HFDvsChow)
create_GlobalBarplot(CompTreatTable = VertexClassesSharedGenes_HFDvsChow,
                     treat1 = "HFD",
                     treat2 = "Chow",
                     factorOrder = c("HFD","Chow"),
                     col1="red",
                     col2 ="blue",
                     maxpairs = 1,
                     szggrepel = 6,
                     szaxisTxt = 15,
                     szaxisTitle = 15,
                     xlb = "Metabolite-pair classes")
}
