% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{getVertexsPerEdgeFeature_and_Grid}
\alias{getVertexsPerEdgeFeature_and_Grid}
\title{Vertex-Class profile per edge feature Side-by-Side (two treatments)}
\usage{
getVertexsPerEdgeFeature_and_Grid(
  CompTreatTable,
  Treat1,
  Treat2,
  Annotation,
  chunks = 3,
  ggrep = TRUE,
  xlb = "Edge Feature",
  onlyT = FALSE,
  small = FALSE,
  ...
)
}
\arguments{
\item{CompTreatTable}{Output of Compare_VertexClasses_sharedEdgeFeatures}

\item{Treat1}{Name treatment 1 as in table CompTreatTable}

\item{Treat2}{Name treatment 2 as in table CompTreatTable}

\item{Annotation}{Data frame that includes the rgb colors for every class. The column 'class' (or 'Class') has to be present and also the column 'ColorRgb'}

\item{chunks}{To avoid a non readable dense plot the results can be spitted in multiple plots}

\item{ggrep}{logical. If TRUE includes ggrepel labels for every bar}

\item{xlb}{Change the x-axis label}

\item{onlyT}{logical. If TRUE a table is returned instead of a grid of plots}

\item{small}{logical. If only a few edge features are in the input set as TRUE. A single plot will be created}

\item{...}{Other parameters for inner functions, mainly ggplot2 visual parameters}
}
\value{
A gtable containing side-by-side barplots, one for each treatment, showing the number of vertex features per class for every shared edge feature
}
\description{
This function creates a grid of barplots. The barplot of one side depicts the number of class vertex features per edge feature for treatment 1 and the other side the same barplot for treatment 2. Results of both Treatments are side by side for better comparison.
}
\examples{
data(VertexClassesSharedGenes_HFDvsChow)
VCSGs<-VertexClassesSharedGenes_HFDvsChow
data(MetColorTable)
HFD_vs_Chow_LCP_Gene<-getVertexsPerEdgeFeature_and_Grid(VCSGs,
                                                        "HFD","Chow",
                                                        Annotation=MetColorTable,
                                                        ggrep=FALSE,
                                                        small = FALSE,
                                                        chunks = 3,
                                                        szLegendKey=0.2)
plot(HFD_vs_Chow_LCP_Gene)
}
