% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WALD.R
\name{WALD}
\alias{WALD}
\title{WALD: Wald Method for Simultaneous Confidence Intervals}
\usage{
WALD(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed cell counts corresponding to a
categorical dataset. All values must be non-negative.}

\item{alpha}{Desired statistical significance level}
}
\value{
Prints the original and adjusted confidence intervals for each category,
along with the volume (product of interval widths).
}
\description{
Computes simple Wald-type simultaneous confidence intervals for multinomial
proportions. These intervals are symmetric about the sample proportions and
do not use continuity corrections, thus avoiding zero-width intervals even
for extreme sample proportions.
}
\details{
The adjusted limits are truncated to stay within the [0,1] range.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
WALD(y, z)

}
\references{
Wald, A. (1943).
*Tests of Statistical Hypotheses Concerning Several Parameters When the Number of Observations is Large.*
Transactions of the American Mathematical Society, **54**, 426–482.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALDCC}}, \code{\link{SG}}
}
\author{
Dr. M. Subbiah
}
