% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coincident_profile.R
\name{coincident_profile}
\alias{coincident_profile}
\title{Coincident Profile}
\usage{
coincident_profile(x, y, frequ = 12, MLag = 6, nvar1 = "name.x",
  nvar2 = "name.y", print.graf = FALSE, iyear = 1,
  lyear = numeric(), imonth = 12, lmonth = numeric(),
  tit1 = "Title.x", tit2 = "Title.y", tit3 = "Title.x.y")
}
\arguments{
\item{x}{Univariate time series}

\item{y}{Univariate time series}

\item{frequ}{Frequency of x and y. x and y must have the same frequency}

\item{MLag}{Maximum lag for the coincident profile}

\item{nvar1}{Name of x}

\item{nvar2}{Name of y}

\item{print.graf}{If TRUE returns a panel 2x2 where the superior panel has both
plots of x and y with their turning points (maximums black dots lines and minimums red dots lines).
The inferior left panel has the matplot of x and y standardized, respectively (x-mean(x))/sd(x).
The inferior right panel has the coincident profile where \emph{TP} shows the number
of turning points used.}

\item{iyear}{The year of the first observation. A single number}

\item{lyear}{The year of the last observation. A single number}

\item{imonth}{The amount of months for the first year. A single number}

\item{lmonth}{The amount of months for the last year. A single number}

\item{tit1}{Title for the plot x}

\item{tit2}{Title for the plot y}

\item{tit3}{Title for the plot x and y}
}
\value{
The coincident profile
}
\description{
Returns the coincident profile developed by Martinez et al. (2016).
 The ideal result is finding the maximum p-value for the lag = 0; otherwise
 maximum p-value for negative lags suggest leading from x to y, or maximum
 p-value for positive lags suggest leading from y to x.
}
\details{
The main output contains two objects: the coincident
 profile (Profile) and both the lag which has the highest probability and
 the number of turning points considered to the calculus of the
 coincident profile (MainLag).
}
\examples{
set.seed(123)
w <- seq(-3, 7, length.out = 100)
x1 <- sin(pi*w)+rnorm(100,0,0.1)
x2 <- sin(pi*w-0.1)+rnorm(100,0,0.1)
coincident_profile(x1, x2, 4, 5, "name.x", "name.y", TRUE, 1991, 2015, 4, 4)

# In this example x leads y three periods
set.seed(123)
w <- seq(-3, 7, length.out = 100)
x <- sin(pi*w)+rnorm(100,0,0.1)
y <- sin(pi*w-1)+rnorm(100,0,0.1)
coincident_profile(x, y, 4, 6, "name.x", "name.y", TRUE, 1991, 2015, 4, 4)
}
\references{
Martinez, W and Nieto, Fabio H and Poncela, P (2016)
 "Choosing a dynamic common factor as a coincident index",
 \emph{Statistics and Probability Letters}, (109), 89-98.
 \url{http://dx.doi.org/10.1016/j.spl.2015.11.008}.

Banerji, A., (1999)
 "The lead profile and others non-parametrics tools to evaluate survey
 series as leading indicators",
 \emph{Survey Data for Industry, Research and Economic Policy,
  selected papers presented at the 24th CIRET Conference, Willington, New Zealand.}
}
\author{
Wilmer O Martinez R
}
