% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatbath_multimodal.R
\name{heatbath_multimodal}
\alias{heatbath_multimodal}
\title{Multimodal heatbath algorithm}
\usage{
heatbath_multimodal(net, mod_matrix, spins, alpha, temp, max_sweeps)
}
\arguments{
\item{net}{a \code{hms_network} object}

\item{mod_matrix}{mod_matrix}

\item{spins}{spins}

\item{alpha}{a double parameter balancing the use of the guidance matrix in
modularity calculation}

\item{temp}{a double parameter found using the find_start_temp() function}

\item{max_sweeps}{an integer parameter of the maximum number of sweeps
allowed at each temperature}
}
\value{
acceptance value of the algorithm for the given temperature
}
\description{
Description of the multimodal heatbath algorithm function.
}
\details{
This is one of the two workhorse functions for the algorithm. The heatbath
algorithm selects a network node at random, calculates the multimodal
modularity for the current configuration, and then switches its community
assignment to each possible community. If the modularity of this iterated
configuration is less than the current configuration, the new configuration
is accepted and the algorithm moves on to the next randomly chosen node. If
this is not the case, the node is moved to the new community assignment with
some probability, which is a function of the current modularity value, the
iterated value, and the system's temperature. Once the algorithm finishes
with the randomly chosen node, this counts as a sweep. A new sweep occurs,
with the same steps taken as above, until the sweep number maxes out (usually
set to 50 to balance computation time with robustness).
}
