% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/production.R
\name{production}
\alias{production}
\title{Extract production rates}
\usage{
production(x, ...)
}
\arguments{
\item{x}{A valid \code{cfp_pfres()} or \code{cfp_fgres()} object.}

\item{...}{Further parameters passed on to \code{efflux()} in case of
\code{cfp_fgres}.}
}
\value{
data.frame with \code{prod_abs} (\eqn{µmol / m^2 / s}),
\code{efflux} (\eqn{µmol / m^2 / s}) and \code{prod_rel} where
\eqn{prod_{rel} = efflux / prod_{abs}}.
}
\description{
Easily extract the production of \code{cfp_pfres()} and
\code{cfp_fgres()} models per layer defined in \code{layers_map()} and
calculate the relative contribution per layer.
}
\details{
For a \code{pro_flux()} model, the extraction is straightforward and
simply the product of the optimised production rate (per volume) multiplied
by the height of the layer.

For \code{fg_flux()}, the assumption is made that the production of the
layer \eqn{i} is the difference of the flux in the layer above
\eqn{F_{i+1}} and the layer below \eqn{F_{i-1}}. The flux below the lowest
layer is assumed to be zero and the flux above the topmost layer is the
efflux. This approach has some uncertainties and it should be evaluated if
it applies to your model.

If there are error estimates available from a call to \code{\link[=bootstrap_error]{bootstrap_error()}},
the errors are propagated as follows:
\deqn{\Delta prod_{rel} = |\Delta efflux \cdot
\frac{prod_{abs}}{efflux^2}| +
|\Delta prod_{abs}\cdot\frac{1}{efflux}|}
}
\examples{
PROFLUX <- pro_flux(base_dat)

production(PROFLUX)

}
