% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MajoritySingleVetoGame.R
\name{majoritySingleVetoGame}
\alias{majoritySingleVetoGame}
\title{Construct a weighted majority game with a single veto player}
\usage{
majoritySingleVetoGame(n, vetoPlayer)
}
\arguments{
\item{n}{represents the number of players}

\item{vetoPlayer}{represents the veto player}
}
\value{
A list with three elements 
representing the specified weighted majority game with 
a single veto player (n, vetoPlayer, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified weighted majority game with a single veto player:}\cr
If coalition \code{S} has at least 2 members and if the veto player is part of the
coalition it generates a value of \code{1}, otherwise \code{0}. \cr
Note that weighted majority games with a single veto player are always simple games.
}
\section{Related Functions}{
 
\link{majoritySingleVetoGameValue}, \link{majoritySingleVetoGameVector}
}

\examples{
library(CoopGame) 
majoritySingleVetoGame(n=3, vetoPlayer=1)

}
\references{
Jackson M.O. (2008)  \emph{Social and Economic Networks}, Princeton University Press, p. 415
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
