% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubleAssay.R
\name{doubleAssay}
\alias{doubleAssay}
\title{Detection of co-occurring mutations using double-assay information}
\usage{
doubleAssay(nucmerr = nucmerr, assay1 = assay1, assay2 = assay2, outdir = NULL)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{assay1}{Information of the first assay(containing primers
locations and probe location, see the format of assays provided as
example data. e.g. data(assays); assay1<- assays[1,])}

\item{assay2}{Information of the second assay, the format is the
same as the first assay.}

\item{outdir}{The output directory. If NULL print the plot in Rstudio.}
}
\value{
Plot three figures in a single panel, including two results of assays and a
"venn" plot for co-occurring mutated samples.
}
\description{
The detection of SARS-CoV-2 is important for the
prevention of the outbreak and management of patients.
Real-time reverse-transcription polymerase chain reaction (RT-PCR)
assay is one of the most effective molecular diagnosis strategies
to detect virus in clinical laboratory. It will be more accurate
and practical to use double assays to detect some samples with
co-occurring mutations.
}
\examples{
data("nucmerr")
data("assays")
assay1 <- assays[1,]
assay2 <- assays[2,]
#outdir <- tempdir()
doubleAssay(nucmerr = nucmerr,
            assay1 = assay1,
            assay2 = assay2,
            outdir = NULL)
}
