% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucmerRMD.R
\name{nucmerRMD}
\alias{nucmerRMD}
\title{Preprocess "nucmer" object to add group information}
\usage{
nucmerRMD(nucmer = nucmer, outdir = NULL, chinalist = chinalist)
}
\arguments{
\item{nucmer}{An object called "nucmer", mutation information derived from
"nucmer.snp" variant file by "seqkit" software and "nucmer SNP-calling"
scripts.}

\item{outdir}{The output directory.}

\item{chinalist}{A list of places in China, for displacing some original cities with "China" in order
to make the downstream analysis easier.}
}
\value{
Saving the updated "nucmer" object.
}
\description{
Manipulate the "nucmer" object to make the analysis easier.
}
\examples{
data("nucmer")
data("chinalist")
#outdir <- tempdir()
nucmerr<- nucmerRMD(nucmer = nucmer, outdir = NULL, chinalist = chinalist)
}
