#' Soil Texture and Plant Available Water Capacity (AWC)
#'
#' AWC is the amount of water between field capacity and permanent wilting
#'  point.  Given in millimetre of water per metre of soil.
#'
#' @references Irrigation Scheduling: The Water Balance Approach Fact Sheet No.
#'  4.707 by A. A. Andales, J. L. Chávez, T. A. Bauder.
#'
#' @format
#'  A data frame with 4 columns and 12 rows:
#'  \describe{
#'    \item{Soil.Texture}{Soil Texture}
#'    \item{AWC.Low}{Available water capacity in millimetre of water per
#'      centimetre of soil}
#'    \item{AWC.High}{Available water capacity in millimetre of water per
#'       centimetre of soil}
#'    \item{AWC.Average}{Available water capacity in millimetre of water per
#'      metre of soil}
#'    }
#'
#' @source
#'    <https://extension.colostate.edu/topic-areas/agriculture/irrigation-scheduling-the-water-balance-approach-4-707/>
"DataForAWC"
