% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ET0_HS.R
\name{ET0_HS}
\alias{ET0_HS}
\title{Reference Evapotranspiration Using Hargreaves-Samani Method}
\usage{
ET0_HS(Ra, Tavg, Tmax, Tmin)
}
\arguments{
\item{Ra}{A \code{vector}, 1-column \code{matrix} or \code{data.frame} with extraterrestrial solar
radiation in \acronym{MJ m-2 day-1}.}

\item{Tavg}{A \code{vector}, 1-column \code{matrix} or \code{data.frame} column with daily average air
temperature.}

\item{Tmax}{A \code{vector}, 1-column \code{matrix} or \code{data.frame} with daily maximum air
temperature in Celsius degrees.}

\item{Tmin}{A \code{vector}, 1-column \code{matrix} or \code{data.frame} with daily minimum air
temperature in Celsius degrees.}
}
\value{
A \code{matrix} of 1-column with the same length as `the input values with the
daily potential evapotranspiration values in millimetres.
}
\description{
Calculates daily reference evapotranspiration amounts using the
Hargreaves-Samani method.
}
\examples{
# See `?DataForCWB` for more on this data set
Tavg <- DataForCWB[, 2]
Tmax <- DataForCWB[, 3]
Tmin <- DataForCWB[, 4]
Ra <- DataForCWB[, 5]
ET0_HS(Ra = Ra, Tavg = Tavg, Tmax = Tmax, Tmin = Tmin)
}
\seealso{
\code{\link[=ET0_PM]{ET0_PM()}} \code{\link[=ET0_PT]{ET0_PT()}}
}
