% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curriculum_graph_from_csv.R
\name{curriculum_graph_from_csv}
\alias{curriculum_graph_from_csv}
\title{Create Curriculum From CSV File}
\usage{
curriculum_graph_from_csv(filepath)
}
\arguments{
\item{filepath}{A csv file path with a table where each row is a course and the columns are as follows:
\itemize{
\item id: an integer id for the course
\item label: a string with the name of the course
\item term: an integer specifying what term the course is to be taken
\item requisites: a list of all pre- and co-requisite course ids of the form 1;2;3;...
}}
}
\value{
A list that contains the following: \item{node_list}{A dataframe of
course nodes containing their id, term, blocking factor (bf), delay
factor (df), centrality (cf), and cruciality (sc)} \item{edge_list}{A
dataframe with two columns 'from' and 'to' specifying directed edges
starting at 'from' nodes directed towards 'to' nodes.} \item{network}{Igraph
network object representing the curriculum graph} \item{sc_total}{Total
structural complexity of the curriculum graph} \item{bf_total}{Total
blocking factor of the curriculum graph} \item{df_total}{Total delay factor
of the curriculum graph}
}
\description{
Generates a curriculum graph from a csv file.
}
\examples{
# Have filepath point to a csv of the following form
#id	label	term	requisites
#1	MATH 100	1
#2	DATA 101	1
#3	MATH 101	2	1
#4	MATH 221	2	3
#5	STAT 230	3	3;2
filepath <-
system.file("extdata", "Example-Curriculum.csv", package = "CurricularAnalytics")
C <- curriculum_graph_from_csv(filepath)
plot_curriculum_graph(C)

}
