% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_factor.R
\name{delay_factor}
\alias{delay_factor}
\title{Calculate delay factor}
\usage{
delay_factor(node_list, edge_list)
}
\arguments{
\item{node_list}{Dataframe with an 'id' column for each node and a
'term' column specifying which term the course is to be taken in.}

\item{edge_list}{Dataframe with two columns 'from' and 'to' specifying
directed edges starting at 'from' nodes directed towards 'to' nodes. Entries
must use node ids from \code{node_list}.}
}
\value{
A list that contains the following: \item{bynode}{A dataframe
containing the delay factor of each node} \item{total}{The total delay
factor of the curriculum graph}
}
\description{
A helper function for calculating the delay factor for each node and the total
delay factor of a curriculum graph.
}
\details{
The delay factor of a course is the longest path the nodes finds itself on.
More formally the delay factor of a node \eqn{v_k} is given by
\deqn{d_c(v_k)=\underset{i,j,l,m}{max}\left\{\#\left(v_i
\overset{p_l}{\to} v_k \overset{p_m}{\to} v_j
\right)\right\}}
The delay factor of an entire curriculum graph \eqn{G_c} is defined as
\deqn{d(G_c)=\sum_{v_k \in V}d_c(v_k)}
}
\examples{
edge_list <- data.frame(from = c(1, 3), to = c(3, 4))
node_list <-
data.frame(
 id = 1:4,
 label = c("MATH 100", "DATA 101", "MATH 101", "MATH 221"),
 term = c(1, 1, 2, 2)
)

df_list <- delay_factor(node_list,edge_list)
print(df_list)
# Output:
# $bynode
#   id df
# 2  1  3
# 3  2  1
# 4  3  3
# 5  4  3
# $total
# [1] 10
}
\references{
Heileman, Gregory L, Chaouki T Abdallah, Ahmad Slim, and Michael
Hickman. 2018. “Curricular Analytics: A Framework for Quantifying the Impact
of Curricular Reforms and Pedagogical Innovations.” arXiv Preprint
arXiv:1811.09676.
}
\author{
Daniel Krasnov
}
