% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_to_nest.R
\name{aggregate_sessions_to_path}
\alias{aggregate_sessions_to_path}
\title{Aggregate a data.frame in long format with a column containing steps of each session
For instance the function can be used with a frame of the form Unique ID - Step - Value 1 - ... -Value N}
\usage{
aggregate_sessions_to_path(data, step_col = "step", id_col = "ID",
  values_cols = NULL, agg_function_path = sum, agg_function_session = sum,
  sep = "->")
}
\arguments{
\item{data}{A dataframe}

\item{step_col}{The name of the column containig the steps. The steps are assumed to be ordered}

\item{id_col}{Column containing the unique identifier of each session}

\item{values_cols}{Names of the other columns to keep. Default: NULL}

\item{agg_function_path}{Aggregation function on a path level}

\item{agg_function_session}{Aggregation function on a session level}

\item{sep}{String used to separate the different steps. Default: "->"}
}
\value{
A data.table with the columns specified in count_col, value_cols and one column per step in the path
}
\description{
Aggregate a data.frame in long format with a column containing steps of each session
For instance the function can be used with a frame of the form Unique ID - Step - Value 1 - ... -Value N
}
