% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_ONEcolonist.R
\name{DAISIE_ONEcolonist}
\alias{DAISIE_ONEcolonist}
\title{Convert intermediate output to final simulation output}
\usage{
DAISIE_ONEcolonist(time, island_spec, stt_table)
}
\arguments{
\item{time}{Numeric defining the length of the simulation in time units.
For example, if an island is known to be 4 million years old, setting
time = 4 will simulate the entire life span of the island; setting time = 2
will stop the simulation at the mid-life of the island.}

\item{island_spec}{Matrix with current state of simulation containing number
of species.}

\item{stt_table}{Matrix with number of species at each time step.}
}
\value{
a list with these elements:
\itemize{
  \item{[1]: \code{stt_table}, the same stt_table as put in.}
  \item{[2]: \code{branching_times}, a sorted numeric vector, as required
    by the ML estimation functions. The first element always refers to
    the island age. Subsequent elements refer to colonisation, speciation and
    recolonisation times. The most recent recolonisation time, if any is
    always omitted to approximate simulation results to the mathematical
    formulation of the likelihood functions used for MLE.}
  \item{[3]: \code{stac}, status of colonist. In this function it can be
    returned as either 2, 4 or 3. If \code{stac} is 2, then there is only one
    independent colonisation present on the island and the extant species are
    endemic. If stac is 4, then only a singleton endemic is present at the
    present. If stac is 3, then recolonisation occurred, and more than one
    colonising lineage.}
  \item{[4]: \code{missing_species}, a numeric value with the number of
    missing species, that is, species not sampled in the phylogeny but
    present on the island. As this code only runs for simulation models,
    here \code{missing_species} is always set to 0.}
  \item{[5]:
  \code{all_colonisations}, on recolonising lineages only. It is comprised of
    \code{$event_times} and \code{$species_type}:
    \describe{
      \item{\code{$event_times}}{ordered numeric vectors containing all
      events for each extant recolonising lineage. This includes all
      colonisation and branching times. Each vector pertains to one
      colonising lineage.}
      \item{\code{$species_type}}{a string. Can be \code{"A"}, \code{"C"} or
      \code{"I"} depending on whether the extant clade is of anagenetic,
      cladogenetic or immigrant origin, respectively.}
    }
  }
}
}
\description{
Convert intermediate output to final simulation output
}
\keyword{internal}
