#' Object resulting from the fit of a double additive location-scale model (DALSM).
#'
#' @description An object returned by the \code{\link{DALSM}} function: this is a list
#' with various components related to the fit of a double additive location-scale model using Laplace P-splines.
#'
#' @return A \code{DALSM} object has the following elements:
#'
#' Essential part:
#' \itemize{
#' \item{\code{converged} : \verb{ }}{logical convergence indicator.}
#' \item{\code{derr} : \verb{ }}{estimated standardized error distribution returned as a \link{densLPS.object}.}
#' \item{\code{psi1} : \verb{ }}{estimated regression parameters for location (fixed effects, B-spline coefs for the J1 additive terms).}
#' \item{\code{psi2} : \verb{ }}{estimated regression parameters for dispersion (fixed effects, B-spline coefs for the J2 additive terms).}
#' \item{\code{fixed.loc} : \verb{ }}{matrix with the estimated fixed effects (est,se,ci.low,ci.up) in the location sub-model.}
#' \item{\code{fixed.disp} : \verb{ }}{matrix with the estimated fixed effects (est,se,ci.low,ci.up) in the dispersion sub-model.}
#' \item{\code{mu} : \verb{ }}{n-vector with the fitted conditional mean.}
#' \item{\code{sd} : \verb{ }}{n-vector with the fitted conditional standard deviation.}
#' }
#' Additional elements:
#' \itemize{
#' \item{\code{data} : \verb{ }}{the original data frame used when calling the \code{\link{DALSM}} function.}
#' \item{\code{phi} : \verb{ }}{estimated B-spline coefs for the log-hazard of the error distribution.}
#' \item{\code{K.error} : \verb{ }}{number of B-splines used to approximate the log of the error hazard.}
#' \item{\code{rmin, rmax} : \verb{ }}{minimum and maximum values for the support of the standardized error distribution.}
#' \item{\code{knots.error} : \verb{ }}{equidistant knots on (rmin,rmax) used to specify the B-spline basis for the log of the error hazard.}
#' \item{\code{bread.psi1, Sand.psi1, Cov.psi1}: \verb{ }}{estimated Variance-Covariance matrix for \eqn{\psi_1}.}
#' \item{\code{U.psi1} : \verb{ }}{gradient for \eqn{\psi_1}.}
#' \item{\code{bread.psi2, Sand.psi2, Cov.psi2}: \verb{ }}{estimated Variance-Covariance matrix for \eqn{\psi_2}.}
#' \item{\code{U.psi2} : \verb{ }}{gradient for \eqn{\psi_2}.}
#' \item{\code{U.psi} : \verb{ }}{gradient for \eqn{\psi=(\psi_1,\psi_2)}.}
#' \item{\code{Cov.psi} : \verb{ }}{variance-covariance for \eqn{\psi=(\psi_1,\psi_2)}.}
#' \item{\code{regr1} : \verb{ }}{object generated by \code{\link{DesignFormula}} for the specified submodel for location.}
#' \item{\code{regr2} : \verb{ }}{object generated by \code{\link{DesignFormula}} for the specified submodel for dispersion.}
#' \item{\code{res} : \verb{ }}{n-vector or nx2 matrix (if IC data) with the standardized residuals for the fitted model.}
#' \item{\code{expctd.res} : \verb{ }}{n-vector with observed standardized residual for a non RC unit, or their expected value if right-censored.}
#' \item{\code{REML} : \verb{ }}{logical indicating whether REML estimation was performed.}
#' \item{\code{n} : \verb{ }}{the sample size.}
#' \item{\code{n.uncensored} : \verb{ }}{number of non-censored response data.}
#' \item{\code{event} : \verb{ }}{n-vector of event indicators (1: non right-censored ; 0: right censoring).}
#' \item{\code{is.IC} : \verb{ }}{n-vector with interval censoring indicators.}
#' \item{\code{n.IC} : \verb{ }}{number of interval-censored response data.}
#' \item{\code{n.RC} : \verb{ }}{number of right-censored response data.}
#' \item{\code{perc.obs} : \verb{ }}{percentage of exactly observed response data.}
#' \item{\code{perc.IC} : \verb{ }}{percentage of interval-censored response data.}
#' \item{\code{perc.RC} : \verb{ }}{percentage of right-censored response data.}
#' \item{\code{cred.int} : \verb{ }}{nominal level for the reported credible intervals.}
#' \item{\code{alpha} : \verb{ }}{user-specified \eqn{\alpha} with Bayesian \eqn{(1-\alpha)} credible intervals reported.}
#' \item{\code{sandwich} : \verb{ }}{logical indicating if variance-covariance and standard errors computed using sandwich estimator in the NP case.}
#' \item{\code{diag.only} : \verb{ }}{logical indicating if the correction to the Hessian under REML only concerns diagonal elements.}
#' \item{\code{iter} : \verb{ }}{number of iterations.}
#' \item{\code{elapsed.time} : \verb{ }}{time required by the model fitting procedure.}

#' }
#' If there are additive terms in the location submodel:
#' \itemize{
#' \item{\code{K1} : \verb{ }}{number of B-splines used to describe an additive term in the location submodel.}
#' \item{\code{xi1} : \verb{ }}{matrix with the selected log penalty parameters for the J1 additive terms in the location submodel (point estimate, se, ci.low, ci.up.}
#' \item{\code{U.xi1} : \verb{ }}{gradient for the log of the penalty parameters for the J1 additive terms in the location submodel.}
#' \item{\code{U.lambda1} : \verb{ }}{gradient for the penalty parameters for the J1 additive terms in the location submodel.}
#' \item{\code{Cov.xi1} : \verb{ }}{estimated Variance-Covariance matrix for the parameters involved in the J1 additive terms in the location submodel.}
#' \item{\code{lambda1.min} : \verb{ }}{minimal value for the penalty parameters in the additive submodel for location.}
#' \item{\code{lambda1} : \verb{ }}{matrix with the selected penalty parameters for the J1 additive terms in the location submodel (point estimate, se, ci.low, ci.up).}
#' \item{\code{ED1} : \verb{ }}{matrix with the effective dimensions for each of the J1 additive terms in the location submodel (point estimate,ci.low,ci.up).}
#' }
#' If there are additive terms in the dispersion submodel:
#' \itemize{
#' \item{\code{K2} : \verb{ }}{number of B-splines used to describe an additive term in the dispersion submodel.}
#' \item{\code{xi2} : \verb{ }}{matrix with the selected log penalty parameters for the J2 additive terms in the dispersion submodel (point estimate, se, ci.low, ci.up).}
#' \item{\code{U.xi2} : \verb{ }}{gradient for the log of the penalty parameters for the J2 additive terms in the dispersion submodel.}
#' \item{\code{U.lambda2} : \verb{ }}{gradient for the penalty parameters for the J2 additive terms in the dispersion submodel.}
#' \item{\code{Cov.xi2} : \verb{ }}{estimated Variance-Covariance matrix for the parameters involved in the J2 additive terms in the dispersion submodel.}
#' \item{\code{lambda2.min} : \verb{ }}{minimal value for the penalty parameters in the additive submodel for dispersion.}
#' \item{\code{lambda2} : \verb{ }}{matrix with the selected penalty parameters for the J2 additive terms in the dispersion submodel (point estimate, se, ci.low, ci.up).}
#' \item{\code{ED2} : \verb{ }}{matrix with the effective dimensions for each of the J2 additive terms in the dispersion submodel (point estimate,ci.low,ci.up).}
#' }
#'
#' @author Philippe Lambert \email{p.lambert@uliege.be}
#' @references Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
#' in nonparametric double additive location-scale models with right- and
#' interval-censored data.
#' \emph{Computational Statistics and Data Analysis}, 161: 107250.
#' <doi:10.1016/j.csda.2021.107250>
#'
#' @seealso \code{\link{DALSM}}, \code{\link{print.DALSM}}, \code{\link{plot.DALSM}}, \code{\link{densityLPS}}, \code{\link{densLPS.object}}
#'
#' @name DALSM.object
NULL

