% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{bounded_scale_value}
\alias{bounded_scale_value}
\title{bounded_scale_value}
\usage{
bounded_scale_value(value, scale)
}
\arguments{
\item{value}{Any DEXi value, including value sets and distributions.}

\item{scale}{A \link{DexiScale} or derived object.}
}
\value{
For continuous scales, \code{value} is returned "as is". For discrete scales, all elements
of \code{value} that lie outside of \code{scale$full_range()} are removed. If this results in
an empty value set or distribution, \code{NULL} is returned.
}
\description{
\code{bounded_scale_value} is a wrapper around \code{\link[=scale_value]{scale_value()}} that makes sure that
the resulting values lie within the bounds set up by the \code{scale}.
}
\examples{
scl <- DexiDiscreteScale(values = c("low", "med", "high"))
bounded_scale_value(NA, scl)                               # NA
bounded_scale_value(1, scl)                                # 1
bounded_scale_value(4, scl)                                # NULL
bounded_scale_value(c(0, 1, 3,  4, 5), scl)                # c(1, 3)
bounded_scale_value(distribution(0.1, 0.2, 0.3, 0.4), scl) # distribution(0.1, 0.2, 0.3)

}
\seealso{
\code{\link[=scale_value]{scale_value()}}
}
