% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{compare_two_alternatives}
\alias{compare_two_alternatives}
\title{compare_two_alternatives}
\usage{
compare_two_alternatives(alt1, alt2, attributes, deep = TRUE)
}
\arguments{
\item{alt1}{\code{data.frame}. First alternative.}

\item{alt2}{\code{data.frame}. Second alternative.}

\item{attributes}{Vector of \link{DexiAttribute} objects.}

\item{deep}{\code{logical(1)}. When \code{TRUE} and compared values are equal,
input attributes are additionally investigated for possible preferential differences.}
}
\value{
\code{numeric(length(attributes))}.
Each element represents the outcome of comparison w.r.t. the corresponding attribute.
Possible outcomes:
\describe{
\item{\code{0}}{Values are equal.}
\item{\code{-1}}{\code{alt1}'s value is worse than \code{alt2}'s.}
\item{\code{+1}}{\code{alt1}'s value is better than \code{alt2}'s.}
\item{\code{NA}}{Values are incomparable.}
}

When \code{deep = TRUE}, the so-called deep comparison is performed:
when the compared attribute's values are equal,
subordinate attributes are checked for differences, possibly returning
\code{-0.5} (indicating the weak preference relation "<=") or
\code{+0.5} (indicating the weak preference relation ">=").
}
\description{
Compare alternatives \code{alt1} and \code{alt2} with respect to \code{attributes}.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

compare_two_alternatives(Car$alternatives[1,], Car$alternatives[2,], Car$attributes)
# c(NA, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1)
}
\seealso{
\code{\link[=compare_values_on_scale]{compare_values_on_scale()}}
}
