% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{dexi_option_value}
\alias{dexi_option_value}
\title{dexi_option_value}
\usage{
dexi_option_value(x)
}
\arguments{
\item{x}{\code{character(1)}. Contains a sequence of characters, each of which represents an individual ordinal number.}
}
\value{
A numeric vector. The conversion uses \code{rule_values(x, add = 1)}.
For special-type parameters, the conversion results are:
\preformatted{
 x                              result
 ------------------------------+------
 NULL                           NULL
 a non-character object         NA
 "" or "*"                      "*"
 a string starting with "undef" NA
}
}
\description{
Conversion of a string to a "DEXi value" (see \link{DEXiR-package}) according to "old"
DEXi syntax. In \code{.dxi} files, the old syntax is used with \code{OPTION} XML tags.
The reason for replacing the old with the new syntax (see \code{\link[=dexi_value]{dexi_value()}}) was
that the old syntax can not unambiguously represent value distributions.
}
\examples{
dexi_option_value(NULL)
dexi_option_value(NA)
dexi_option_value("")
dexi_option_value("*")
dexi_option_value("undef")
dexi_option_value("1")
dexi_option_value("012")


}
\seealso{
\link{DEXiR-package}, \code{\link[=dexi_value]{dexi_value()}}, \code{\link[=rule_value]{rule_value()}}
}
