% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{evaluate_attributes}
\alias{evaluate_attributes}
\title{evaluate_attributes}
\usage{
evaluate_attributes(model, alternative, attributes = NULL, ...)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternative}{A \code{data.frame} containing a single alternative.}

\item{attributes}{List of attributes or vector of attribute names, ID's or indices.
Default: All basic attributes of \code{model}.}

\item{...}{Optional parameters passed to \code{\link[=evaluate_attribute]{evaluate_attribute()}}.}
}
\value{
A list of \code{\link[=evaluate_attribute]{evaluate_attribute()}} results for each \code{attribute}
}
\description{
Apply \code{evaluate_attribute()} for all discrete \code{attributes}.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY="medium")
safety <- Car$attrib("SAFETY")
# Perform evaluate_attribute() for all basic attributes of CarDxi
evaluate_attributes(Car, alt)
# Returns a list of evaluate_attribute() results corresponding to all basic attributes,
# indexed by attribute id
}
\seealso{
\code{\link[=evaluate_attribute]{evaluate_attribute()}}
}
