% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiCharts.R
\name{plotalt_radar}
\alias{plotalt_radar}
\title{plotalt_radar}
\usage{
plotalt_radar(
  model,
  alternatives = NULL,
  attids = NULL,
  aggregate = c("minmax", "min", "max", "mean", "none"),
  name = "name",
  shift = 0.01,
  linewidth = 2,
  ptype = 16,
  colors = NULL,
  unicolors = NULL,
  fillcolors = NULL,
  transparency = 85,
  circular = FALSE,
  split = FALSE,
  fill = FALSE,
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects the whole \code{model$alternatives}.}

\item{attids}{\code{character()}. A character vector of \link{DexiAttribute} IDs to be included in the result.
Default: all \code{model} attributes.}

\item{aggregate}{One of \code{"minmax"}, \code{"min"}, \code{"max"}, \code{"mean"} or "\code{none}". Determines how
to aggregate \code{alternatives} values that are represented by sets or distributions.}

\item{name}{\code{character(1)}, The name of the column in \code{alternatives} that contains
alternatives' names. Default: \code{"name"}.}

\item{shift}{\code{numeric(1)}. Used to "shift" numeric values by a small amount to avoid overlapping
lines in charts. Default: \code{0.01}.
You may want to experiment with charts to determine the right value,}

\item{linewidth}{\code{numeric(1)}. Widths of lines drawn.}

\item{ptype}{A vector to specify point symbol: Default \code{16} (closed circle).
Should be 32 to not plot the points. This vector is repeatedly used for data series.}

\item{colors}{Colors to be used (repeatably) for data series. Default \code{1:8}.}

\item{unicolors}{A vector of one or two colors to be used for displaying the
minimum and maximum data series, respectively. Applies only when \code{split = TRUE}.}

\item{fillcolors}{A vector of color codes for filling polygons. Applies only when \code{fill = TRUE}.}

\item{transparency}{A number between \code{0} and \code{100} representing the transparency of
colors used for filling polygons.}

\item{circular}{\code{logical(1)}. Whether to make a circular (using \code{\link[fmsb:radarchart]{fmsb::radarchartcirc()}})
or polygonal (\code{\link[fmsb:radarchart]{fmsb::radarchart()}}) radar grid.}

\item{split}{\code{logical(1)}. Whether to plot all alternatives on a single chart (\code{FALSE}, default)
or make a series of plots of individual alternatives (\code{TRUE}).}

\item{fill}{\code{logical(1)}. Whether or not to fill polygons using \code{fillcolors}.}

\item{...}{Optional parameters passed to \code{\link[fmsb:radarchart]{fmsb::radarchart()}}.}
}
\value{
Draws a chart or, when \code{split = TRUE} a series of charts corresponding to individual alternatives.
}
\description{
Plots DEXi alternatives on a radar chart.
Generally, axes are uniformly scaled to the \verb{[0,1]} interval.
}
\details{
Uses \code{\link[fmsb:radarchart]{fmsb::radarchart()}} and requires package "fmsb" to be installed.
Data presented in the chart is prepared by \code{\link[=scale_alternatives]{scale_alternatives()}}.
}
\examples{
if (requireNamespace("fmsb", quietly = TRUE)) {

# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Plot all Car$alternatives with points and lines
plotalt_radar(Car)

# Use different colors and fill polygons
plotalt_radar(Car, colors = c("blue", "brown"), fill = TRUE)
plotalt_radar(Car, colors = c("blue", "brown"), fillcolors = c("green", "red"), fill = TRUE)

# Draw separate charts
plotalt_radar(Car, split = TRUE)

# Draw separate charts, using the same color settings on all charts
plotalt_radar(Car, split = TRUE, unicolors = c("green", "red"))
plotalt_radar(Car, split = TRUE, unicolors = c("green", "red"), circular = TRUE)

alts3 <- structure(
list(
  name = c("MyCar", "MyCar2", "MyCar1b"),
    CAR.1 = list(4L, 4L, c(1L, 4L)),
    PRICE = list(3L, 3L, c(1L, 3L)),
    BUY.PRICE = list(3L, 3L, 3L),
    MAINT.PRICE = list(2, 1, structure(c(0.1, 0.6, 0.3), class = "distribution")),
    TECH.CHAR. = list(3L, 3:4, 3L),
    COMFORT = list(3L, 2, 3L),
    X.PERS = list(3, 3, 3L),
    X.DOORS = list(3, 3, 3L),
    LUGGAGE = list(2L, 2L, 2),
    SAFETY = list(2, c(2, 3), 2)
    ),
    row.names = c(NA, -3L),
    class = "data.frame"
 )

# The same chart types as above, but using more varied alternatives data
# Plot all Car$alternatives with points and lines
plotalt_radar(Car, alts3)

# Use different colors and fill polygons
plotalt_radar(Car, alts3, colors = c("blue", "brown", "purple"), fill = TRUE)
plotalt_radar(Car, alts3, colors = c("blue", "brown", "purple"),
  fillcolors = c("green", "red", "yellow"), fill = TRUE)

# Draw separate charts
plotalt_radar(Car, alts3, split = TRUE)
plotalt_radar(Car, alts3, split = TRUE, fill = TRUE)

# Draw separate charts, using the same color settings on all charts
plotalt_radar(Car, alts3, split = TRUE, unicolors = c("red", "green"))
plotalt_radar(Car, alts3, split = TRUE, unicolors = c("green", "darkgreen"), fill = TRUE)
plotalt_radar(Car, alts3, split = TRUE, unicolors = c("red", "green"), circular = TRUE)

}
}
\seealso{
\code{\link[=scale_alternatives]{scale_alternatives()}}, \code{\link[fmsb:radarchart]{fmsb::radarchart()}}
}
