#' Log-likelihood for 2-component lognormal mixture
#' @keywords internal
loglik_lognorm <- function(params, x) {
  p <- params[1]; mu1 <- params[2]; s1 <- params[3]; mu2 <- params[4]; s2 <- params[5]
  if (p <= 0 || p >= 1 || s1 <= 0 || s2 <= 0) return(-1e12)
  d <- p * dlnorm(x, mu1, s1) + (1 - p) * dlnorm(x, mu2, s2)
  sum(log(d + 1e-12))
}

#' Log-likelihood for 2-component normal mixture
#' @keywords internal
loglik_norm <- function(params, x) {
  p <- params[1]; mu1 <- params[2]; s1 <- params[3]; mu2 <- params[4]; s2 <- params[5]
  if (p <= 0 || p >= 1 || s1 <= 0 || s2 <= 0) return(-1e12)
  d <- p * dnorm(x, mu1, s1) + (1 - p) * dnorm(x, mu2, s2)
  sum(log(d + 1e-12))
}
