% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtPars.R
\name{ExtractMirtPars}
\alias{ExtractMirtPars}
\title{Extracts the item parameters from a unidimensional mirt model}
\usage{
ExtractMirtPars(mod, focal = NULL, reference = NULL)
}
\arguments{
\item{mod}{A mirt object containing the fit of unidimensional model.}

\item{focal}{Character. Required if mod is MultipleGroupClass, focal should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}

\item{reference}{Character. Required if mod is MultipleGroupClass, reference should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}
}
\value{
If mod contains any itemtype == "gpcm", a list with the item parameters and the estimate covariances (if available).
If mod is SingleGroupClass, the list contains the item parameters as a matrix and the covariances as a list.
If mod is MultipleGroupClass, the list contains the item parameters and covariances for the focal and reference groups only.


}
\description{
Extracts the item parameters from a unidimensional mirt model
}
\examples{
library(mirt)
(mod1 <- mirt(Science, model = 1, itemtype = c("graded", "graded", "gpcm", "gpcm"), SE = TRUE))
(ExtractMirtPars(mod1))

}
