% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RajuAreas.R
\name{UnsignedArea}
\alias{UnsignedArea}
\title{Calculates Raju's Unsigned Area Measure index for an item with given item parameters of focal and reference groups.}
\usage{
UnsignedArea(
  itemParameters,
  irtModel = "2pl",
  subdivisions = 5000,
  logistic = TRUE
)
}
\arguments{
\item{itemParameters}{A list containing "focal" and "reference" item parameters. Item parameters are assumed to be on the same scale. Item parameters for each group should me a matrix with nrow equal to the number of items.}

\item{irtModel}{A string stating the irtModel to be used. Should be one of "1pl", "2pl", "3pl", "grm" or "pcm".}

\item{subdivisions}{A numeric value indicating the number of subdivisions for numerical integration.}

\item{logistic}{A logical value stating if the IRT model will use the logistic or the normal metric. Defaults to using the logistic metric by fixing the D constant to 1. If FALSE the constant is set to 1.702 so that the normal metric is used.}
}
\value{
uam A numeric matrix with the Unsigned Area Measure values for all the item parameter in each set of itemParameterList
}
\description{
Calculates Raju's Unsigned Area Measure index for an item with given item parameters of focal and reference groups.
}
\examples{

data(dichotomousItemParameters)

threePlParameters <- dichotomousItemParameters
isNot3Pl          <- ((dichotomousItemParameters[['focal']][, 3] == 0) |
                      (dichotomousItemParameters[['reference']][, 3] == 0))

threePlParameters[['focal']]          <- threePlParameters[['focal']][!isNot3Pl, ]
threePlParameters[['reference']]      <- threePlParameters[['reference']][!isNot3Pl, ]
threePlParameters[['focal']][, 3]     <- threePlParameters[['focal']][, 3] + 0.1
threePlParameters[['reference']][, 3] <- threePlParameters[['reference']][, 3] + 0.1
threePlParameters[['focal']][, 2]     <- threePlParameters[['focal']][, 2] + 1.5
threePlParameters[['reference']][, 2] <- threePlParameters[['reference']][, 2] + 1.5
threePlParameters[['focal']]          <- threePlParameters[['focal']][-c(12, 16, 28), ]
threePlParameters[['reference']]      <- threePlParameters[['reference']][-c(12, 16, 28), ]

uam3pl <- UnsignedArea(itemParameters = threePlParameters, irtModel = "3pl",
                       subdivisions = 5000, logistic = TRUE)

}
\references{
Cohen, A., Kim, S-H and Baker , F. (1993). Detection of differential item functioning in the Graded Response Moodel. Applied psychological measurement, 17(4), 335-350. doi:10.1177/014662169301700402

Raju, N. (1988). The area between two item characteristic cureves. Psychometricka, 53(4), 495--502. doi:10.1007/bf02294403
}
\author{
Victor H. Cervantes <vhcervantesb at unal.edu.co>
}
