% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_after_mcem_algorithm.R
\name{gibbs_after_mcem_algorithm}
\alias{gibbs_after_mcem_algorithm}
\title{Generating posterior samples for parameters (other than DGP parameters) in the model and predicted gene expression for one chain.}
\usage{
gibbs_after_mcem_algorithm(
  chain_index,
  mc_num,
  burnin,
  thin_step,
  pathname,
  pred_indicator = FALSE,
  pred_time_index = NULL,
  x,
  mcem_parameter_setup_result,
  mcem_algorithm_result,
  gibbs_after_mcem_diff_initials_result
)
}
\arguments{
\item{chain_index}{A numeric scalar. Index of the chain.}

\item{mc_num}{A numeric scalar. Number of iterations in the Gibbs sampler.}

\item{burnin}{A numeric scalar. Number of iterations to be discarded as 'burn-in'.}

\item{thin_step}{A numeric scalar. This function will only save every 'thin_step'th iteration results in the specified directory to reduce storage space needed. Note that this number can be different from that used in the function 'mcem_algorithm'.}

\item{pathname}{A character. The directory where the saved Gibbs samplers are stored.}

\item{pred_indicator}{A logical value. pred_indicator = TRUE denotes the need to predict gene expression at new time points. The default value is FALSE.}

\item{pred_time_index}{Only needed if pred_indicator = TRUE. Index of the new time points in the full time vector.}

\item{x}{A list of n elements. Each element is a matrix of dimension (p, q_i), storing the gene expression observed at q_i time points for the ith subject.}

\item{mcem_parameter_setup_result}{A list of objects returned from the function 'mcem_parameter_setup'.}

\item{mcem_algorithm_result}{A list of objects returned from the function 'mcem_algorithm'.}

\item{gibbs_after_mcem_diff_initials_result}{A list of objects returned from the function 'gibbs_after_mcem_diff_initials'.}
}
\value{
Posterior samples for parameters (other than DGP parameters) in the model and predicted gene expression for one chain.
}
\description{
Generating posterior samples for parameters (other than DGP parameters) in the model and predicted gene expression for one chain.
}
\details{
This function corresponds to Algorithm 2: Step 1 in the main manuscript; therefore reader can consult the paper for more explanations.
}
\examples{
# See examples in vignette
vignette("bsfadgp_regular_data_example", package = "DGP4LCF")
vignette("bsfadgp_irregular_data_example", package = "DGP4LCF")

}
