% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{listw}
\alias{listw}
\title{Create Spatial Weights List}
\usage{
listw(
  shapefile_path,
  data,
  loc_shape,
  loc_data,
  weight_function = function(d) exp(-d/0.2)
)
}
\arguments{
\item{shapefile_path}{A string specifying the file path to the shapefile.}

\item{data}{A dataframe containing the variables to be analyzed.}

\item{loc_shape}{A string specifying the column name in the shapefile used for merging.}

\item{loc_data}{A string specifying the column name in the dataset that corresponds to the location variable.}

\item{weight_function}{A function to calculate weights from distances. Defaults to `function(d) exp(-d / 0.2)`.}
}
\value{
A spatial weights list object of class `listw`.
}
\description{
This function creates a spatial weights list using a shapefile and a dataset.
}
\examples{
if (requireNamespace("spData", quietly = TRUE)) {
    library(dplyr)
    library(sf)

    # Load US states data
    us_states <- spData::us_states

    # Simplify for demonstration: Select a subset of columns
    us_states_data <- us_states \%>\%
        select(GEOID, NAME) \%>\%
        mutate(mean_wealth = rnorm(nrow(us_states), 50, 10))  # Add mock data

    # Define a temporary shapefile path
    shapefile_path <- tempfile(fileext = ".shp")
    sf::st_write(us_states, shapefile_path, quiet = TRUE)

    # Use the listw function from the package
    us_states_listw <- DHSr::listw(
        shapefile_path = shapefile_path,
        data = us_states_data \%>\% sf::st_drop_geometry(),  # Drop geometry for compatibility
        loc_shape = "GEOID",
        loc_data = "GEOID",
        weight_function = function(d) exp(-d / 0.2)
    )

    # Verify the spatial weights list
    print(us_states_listw)
}
}
