test_that("Replm2 runs linear regression across multiple locations correctly", {
  # Create dummy data
  set.seed(123)
  dummy_data <- data.frame(
    years_education = rnorm(100, 12, 3),
    gender_female = rbinom(100, 1, 0.5),
    household_wealth = sample(1:5, 100, replace = TRUE),
    district_code = sample(1:10, 100, replace = TRUE)
  )

  # Define formula
  formula <- years_education ~ gender_female + household_wealth + household_wealth:gender_female

  # Run the function for multiple locations
  result <- Replm2(dummy_data, formula, "district_code", response_distribution = "normal")

  # Test if the result contains the expected columns for estimates and std_error
  expect_true(any(grepl("estimate", colnames(result))))
  expect_true(any(grepl("std_error", colnames(result))))

  # Test if the result contains rows for R-squared
  expect_true(any(grepl("R-squared", colnames(result))))

  # Test if the result has the correct number of rows for all districts
  expect_equal(nrow(result), 10)  # Expect 10 rows, one for each district
})
