% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML.DIF.r
\name{ML.DIF}
\alias{ML.DIF}
\title{Main function to compute adjusted Mantel-Haenszel statistics}
\usage{
ML.DIF (Response.data, Response.code=c(0,1),Cluster, Group, 
       group.names=NULL, Stratum=NULL, correct.factor=0.85, 
       missing.code="NA", missing.impute="LW", 
       anchor.items=NULL, purification=FALSE, 
       max.iter=10, alpha = .05)
}
\arguments{
\item{Response.data}{A scored item responses matrix in the form of matrix or data frame. This matrix should not include any
other variables (group, stratum, cluser, etc.).}

\item{Response.code}{A numerical vector of all possible item responses. By default, Response.code=c(0,1).}

\item{Cluster}{The cluster variable. Its length should be equal to the sample size of the item response matrix.}

\item{Group}{The variable of group membership (e.g., gender). Its length should be equal to the sample size of the item response matrix.}

\item{group.names}{Names for each defined group (e.g., c('Male','Female')). This argument is optional. By default, group.names=NULL.
If not provided, group names of "Group.1, Group.2, etc." will be automatically generated.}

\item{Stratum}{The matching variable. By default, Stratum=NULL. If not provided, the observed total score will be used.}

\item{correct.factor}{The value of adjustment applied to the adjusted MH statistic (i.e., f). The default value used here is .85. 
The adjusted MH statistic was found to exhibit low statistical power for DIF detection in some conditions. One solution to this 
is to reduce the magnitude of f through multiplying it by the correct factor (e.g., .85, .90, .95). The value of .85 is suggested by
French & Finch (2013) <doi: 10.1177/0013164412472341>.}

\item{missing.code}{Indication of how missing values were defined in the data. By default, missing.code="NA".}

\item{missing.impute}{The approach selected to handle missing item responses. By default, missing.impute="LW", indicating the list-wise
deletion will be used. Other options include: "PM" (person mean or row mean imputation),"IM" (item mean or column mean imputation), 
"TW" (two-way imputation), "LR" (logistic regression imputation), and EM (EM imputation). Check the package "TestDataImputation" 
(\url{https://cran.r-project.org/package=TestDataImputation}) for more details. \cr
Note: If any missing data are detected on group, cluster, or stratum variables, listwise deletion will be used before handling missing item responses.}

\item{anchor.items}{A scored item responses matrix of selected anchor items. This matrix should be a subset of the response data matrix
specified above. By default, anchor.items=NULL.}

\item{purification}{True of false argument, indicating whether purification will be used. By default, purification=FALSE. \cr
Note: Purification will not be applied if anchor items are specified and/or the matching variable is defined.}

\item{max.iter}{The maximum number of iterations for purification. The default value is 10.}

\item{alpha}{The alpha value used to decide on the DIF items. The default value is .05.}
}
\value{
A list of MH statistcs, contigency tables, etc.
\item{MH.values}{Summary of estimated MH statistics and corresponding p-values. Specifically, \cr
 * MH.unadj is the unadjusted MH test statistic.\cr
 * MH.score is the MH statistic based on working score test (Begg, 1999).\cr
 * MH.GMH is the MH test statistic based on Holland & Thayer's (1998) formula. \cr
 * MH.Yates is the MH.GMH statistic with Yates' correction. \cr
 * MH.adj is the adjusted MH statistic for clustered data; \cr
 * f.adj is the adjustment value based on Begg (1999). \cr
 * f.adj.correct is the product of f and the correction factor (.85, etc.). \cr
 * DIF.Item (Yes) = 1 indicates the item is flagged as a DIF item;\cr
 * N.Valid, N.Strata, and N.Cluster refer to the sample size, number of valid stata and cluster that are used in the analysis.}
\item{Stratum.statistics}{summary statistics for each item: n.valid.strata, n.valid.category, 
and also sample sizes for each stratum across items.}
\item{c.table.list.all}{A list that contains all contigency tables across items and strata.}
\item{c.table.list.valid}{A list that contains only valid contigency tables across items and strata. 
Strata that have missign item response categories
or zero marginal means are removed.}
\item{data.out}{A cleaned data set with variables "Group",  "Group.factor","Cluster", "Stratum", 
and all item responses (with missing data handled).}
}
\description{
This main function computes both unadjusted and adjusted MH statistics 
in the presence of clustered data based on Begg (1999) <doi:10.1111/j.0006-341X.1999.00302.x>, Begg & Paykin (2001) 
<doi:10.1080/00949650108812115>, and French & Finch (2013) <doi: 10.1177/0013164412472341>.
}
\details{
This main function computes both unadjusted and adjusted Mantel-Haenszel statistics in the presence of multilevel data.
}
\examples{
#Specify the item responses matrix
data(data.adult)
Response.data<-data.adult[,2:13]
#Run the function with specifications      
ML.DIF.out<-ML.DIF (Response.data, Response.code=c(0,1),Cluster=data.adult$Cluster, 
Group=data.adult$Group, group.names=c('Reference','Focal'), 
Stratum=NULL, correct.factor=0.85, 
missing.code="NA", missing.impute="LW",
anchor.items=NULL, purification=FALSE,
max.iter=10, alpha = .05)
#Obtain results
ML.DIF.out$MH.values
ML.DIF.out$Stratum.statistics
}
\references{
{
Begg, M. D. (1999). 
"Analyzing k (2 × 2) Tables Under Cluster Sampling."
 Biometrics, 55(1), 302-307. doi:10.1111/j.0006-341X.1999.00302.x. 
}

{
Begg, M. D. & Paykin, A. B.  (2001). 
"Performance of and software for a modified mantel-haenszel statistic for correlated data."
 Journal of Statistical Computation and Simulation, 70(2), 175-195. doi:10.1080/00949650108812115.
}

{
French, B. F. & Finch, W. H. (2013). 
"Extensions of Mantel-Haenszel for Multilevel DIF Detection."
 Educational and Psychological Measurement, 73(4), 648-671. 
 doi:10.1177/0013164412472341.
}

{
Holland, P. W. & Thayer, D. T. (1988). 
"Differential item performance and the Mantel-Haenszel procedure."
 In H. Wainer & H. I. Braun (Eds.), Test validity (pp.129-145). Lawrence Erlbaum Associates, Inc.
}
}
